Attribute VB_Name = "modProfiles"
Option Explicit

Public ProfilePointer   As New clsProfileHandler

'---------------------------------------------------------------------------------------
'Description: This module deals with anything that has to do with manipulating profiles.
'             Otherwise known as anything that manipulates the Bots() array.
'---------------------------------------------------------------------------------------

Public Sub addProfile(Bot As BOTINFO)
    If Bots(UBound(Bots)).Profile = vbNullString Then
        Bots(UBound(Bots)) = Bot
        loadBotArrayInfo
    Else
        Bots(UBound(Bots)) = Bot
        loadBotArrayInfo
    End If
    
    'Add menu item
    frmMain.mnuBot(UBound(Bots) - 1).Caption = Bots(UBound(Bots) - 1).Profile
    
    'Make sure menu is not checked
    If (BotIndex <> (UBound(Bots) - 1)) Then
        frmMain.mnuBot(UBound(Bots) - 1).Checked = False
    End If
End Sub

Public Sub delProfile(ByVal Index As Integer)
    With frmMain
        .sckBNET(Index).Close
        .sckBNLS(Index).Close
        .sckREALM(Index).Close
    End With
    
    If (Index < UBound(Bots) And Index > -1) Then
        Call unloadBotArrayInfo(Index)
    End If
End Sub

Public Sub getBots()
    Dim i As Integer
    For i = 0 To UBound(Bots) - 1
        With Bots(i)
            .Username = ReadINI("Profile " & .Profile, "Username", Files.Config)
            .Password = ReadINI("Profile " & .Profile, "Password", Files.Config)
            .P_CDKey = ReadINI("Profile " & .Profile, "Primary_CDKey", Files.Config)
            .E_CDKey = ReadINI("Profile " & .Profile, "Expansion_CDKey", Files.Config)
            .Product = ReadINI("Profile " & .Profile, "Product_ID", Files.Config)
            .Server = ReadINI("Profile " & .Profile, "Server", Files.Config)
            .Home = ReadINI("Profile " & .Profile, "Home", Files.Config)
            .Email = ReadINI("Profile " & .Profile, "Email", Files.Config)
            .Connection = Val(ReadINI("Profile " & .Profile, "Connection", Files.Config))
            'Sub's
            .Change_Pass = Val(ReadINI("Profile " & .Profile, "Change_Password", Files.Config, "Settings"))
            .New_Password = ReadINI("Profile " & .Profile, "New_Password", Files.Config, "Settings")
            .Bot_Plug = Val(ReadINI("Profile " & .Profile, "Bot_Plug", Files.Config, "Settings"))
            .Spoof = Val(ReadINI("Profile " & .Profile, "Spoof", Files.Config, "Settings"))
            .UseRealm = Val(ReadINI("Profile " & .Profile, "Realm", Files.Config, "Settings"))
            .Character = ReadINI("Profile " & .Profile, "Character", Files.Config, "Settings")
        End With
        Call getIndividualOptions(i)
    Next i
End Sub

Private Sub getIndividualOptions(ByRef Index As Integer)
    With ProfileHandler(Index)
        .OPTION_LOG_CHAT = Val(ReadINI("Profile " & Bots(Index).Profile, "Log_Chat", Files.Config, "Settings"))
        '.Idle_Usage = Val(ReadINI("Profile " & Bots(Index).Profile, "Idle", Files.Config, "Settings"))
        '.Greet = Val(ReadINI("Profile " & Bots(Index).Profile, "Greet", Files.Config, "Settings"))
    End With
End Sub


Public Sub getProfiles()
    Dim strInput As String
    Open Files.Config For Input As #1
        Do Until EOF(1)
            Input #1, strInput
            'Search for Profile=<name> field
            If (StrComp(Left$(strInput, 8), "Profile ", vbTextCompare) = 0) Then
                If (InStr(strInput, Space(1))) Then
                    'Get profile name
                    Bots(UBound(Bots)).Profile = Left(Split(strInput, Space(1))(1), 20)
                    'Make sure profile name is not null
                    If (Bots(UBound(Bots)).Profile <> vbNullString) Then
                        'Make sure there aren't equivalent profile names.
                        If (checkConflictingProfileNames(Bots(UBound(Bots)).Profile) = False) Then
                            If (UBound(Bots) = 0) Then
                                frmMain.tsBotsList.Tabs(1).Caption = Bots(UBound(Bots)).Profile
                            End If
                            Call loadBotArrayInfo
                            frmMain.mnuBot(UBound(Bots) - 1).Caption = Bots(UBound(Bots) - 1).Profile
                        Else
                            Call MsgBox("Profile dumped: " & Bots(UBound(Bots)).Profile & vbNewLine & "Reason: Conflicting profile name.", vbCritical, "Error: Conflicting profile name")
                        End If
                    End If
                End If
            End If
        Loop
    Close #1
    
    'Make user create a profile if there are none:
    If (UBound(Bots) = 0) Then
        Call frmConfig.Show
        frmConfig.cmdAdd_Click
        Unload frmConfig
        Call frmConfig.Show(vbModal)
        
        'Set default colors (First time user most likely)
        modColors.setDefaultGUIColors
    End If
End Sub

Public Sub switchProfile(ByRef Index As Integer)
    BotIndex = Index
    Dim i As Integer
    
    If (Index < UBound(Bots)) Then
        With frmMain
            For i = 0 To .mnuBot.UBound
                .mnuBot(i).Checked = False
            Next i
            .mnuBot(Index).Checked = True
            
            'Clear RTB
            .rtbChat = vbNullString
            .rtbWhisper = vbNullString
            
            'Reset Channel List
            .lvUsers.ListItems.Clear
            .tsList.Tabs(1).Selected = True
            
            'Load Channel List
            Call ProfileHandler(Index).UserListing.setChannelListItems(CHANNEL_USER, .lvUsers)
            
            'Set Channel Label (after loading channel list)
            Call updateBotChannel(Index, Bots(Index).CurrentChannel)
            
            'Set RTB information
            'Note: To prevent the addchat lag time, visibility allows us to prevent it. This occurs so quickly the user will not be able to tell. =)
            .rtbChat.Visible = False
            .rtbWhisper.Visible = False
            
            Call ProfileHandler(Index).RTBHandler.setRTBInformation(Index)
            
            .rtbChat.Visible = True
            .rtbWhisper.Visible = True
            
            .rtbChat.SelStart = Len(frmMain.rtbChat.Text)
            .rtbWhisper.SelStart = Len(frmMain.rtbWhisper.Text)
        End With
    End If
End Sub

Public Function getProfileIndex(ProfileName As String) As Integer
Dim i As Integer
    For i = LBound(Bots) To UBound(Bots) - 1
        'Debug.Print Bots(i).Profile & " " & ProfileName
        If (StrComp(Bots(i).Profile, ProfileName, vbTextCompare) = 0) Then
            getProfileIndex = i
            Exit Function
        Else
            getProfileIndex = -1
        End If
    Next i
End Function

Public Function checkConflictingProfileNames(ByVal ProfileName As String) As Boolean
    'True if the profile name is conflicting with other ones.
    Dim i As Integer
    
    For i = 0 To UBound(Bots) - 1
        If (StrComp(Bots(i).Profile, ProfileName, vbTextCompare) = 0) Then
            checkConflictingProfileNames = True
            Exit Function
        End If
    Next i
    checkConflictingProfileNames = False
End Function

Private Sub loadBotArrayInfo()
    'Note: Updates in this require updates in unloadBotArrayInfo
    
    If (UBound(Bots) <> 0) Then
        Load frmMain.mnuBot(UBound(Bots))
        Load frmMain.sckBNET(UBound(Bots))
        Load frmMain.sckBNLS(UBound(Bots))
        Load frmMain.sckREALM(UBound(Bots))
        frmMain.tsBotsList.Tabs.Add , , Bots(UBound(Bots)).Profile
    Else 'If it's the first profile then set the intial tab
        frmMain.tsBotsList.Tabs(1).Caption = Bots(UBound(Bots)).Profile
    End If
    
    ReDim Preserve Bots(UBound(Bots) + 1)
    ReDim Preserve BNETDATA(UBound(BNETDATA) + 1)
    ReDim Preserve ProfileHandler(UBound(ProfileHandler) + 1)
End Sub

Private Sub unloadBotArrayInfo(ByVal Index As Integer)
    Unload frmMain.sckBNET(Index)
    Unload frmMain.sckBNLS(Index)
    Unload frmMain.sckREALM(Index)
    
    'Remove tab on frmMain
    Call frmMain.tsBotsList.Tabs.Remove(Index + 1)
    
    'Remove menu
    Call deleteArrayMenu(Index, frmMain.mnuBot)
    
    Dim i As Integer
    
    For i = Index To UBound(Bots) - 1
        Bots(i) = Bots(i + 1)

        If ((i + 1) < UBound(BNETDATA)) Then        'Just in case
            BNETDATA(i) = BNETDATA(i + 1)
        End If
        
        If ((i + 1) < UBound(ProfileHandler)) Then  'Just in case
            Set ProfileHandler(i) = ProfileHandler(i + 1)
        End If
    Next i
    
    ReDim Preserve Bots(UBound(Bots) - 1)
    ReDim Preserve BNETDATA(UBound(BNETDATA) - 1)
    ReDim Preserve ProfileHandler(UBound(ProfileHandler) - 1)
    
End Sub
